﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

class Plane
{
    public string Identifier
    {
        get;
        set;
    }

    const double kilometersPerMile = 1.609344;

    public double SpeedInMilesPerHour
    {
        get
        {
            return SpeedInKilometersPerHour / kilometersPerMile;
        }
        set
        {
            SpeedInKilometersPerHour = value * kilometersPerMile;
        }
    }

    public double SpeedInKilometersPerHour
    {
        get;
        set;
    }

    public DirectionOfApproach Direction
    {
        get;
        set;
    }

    public PolarPoint3D Position
    {
        get;
        set;
    }

    public void SendMessage(
        string messageName,
        TimeSpan delay = default(TimeSpan))
    {
    }

    // Listing 3-39. Metoda
    public void UpdatePosition(double minutesToAdvance)
    {
        double hours = minutesToAdvance / 60.0;
        double milesMoved = SpeedInMilesPerHour * hours;
        double milesToTower = Position.Distance;
        if (Direction == DirectionOfApproach.Approaching)
        {
            milesToTower -= milesMoved;
            if (milesToTower < 0)
            {
                // Dolecieliśmy!
                milesToTower = 0;
            }
        }
        else
        {
            milesToTower += milesMoved;
        }
        PolarPoint3D newPosition = new PolarPoint3D(
            milesToTower, Position.Angle, Position.Altitude);
    }
}